/*==============================================================================
Infrastructure 

I. Land area 
	a. Bring in EU land area 
	b. Bring in US land area
	c. Bring in CA land area 
II. Motorways
	a. Bring in EU motorways 
	b. Bring in US motorways
		merge with US land area
	c. Bring in CA motorways 
		merge with CA land area
		
III. Merge all motorways data
==============================================================================*/
clear all
set more off
*===============================================================================
* I) Area
*===============================================================================
*-------------------------------------------------------------------------------
* a) EU Land Area 
*-------------------------------------------------------------------------------

insheet using "$insheet_files/Eurostat Web Data/demo_r_d3area_1_Data.csv", name clear
	
gen country = substr(nuts,1,2)
gen insample=0
	
foreach country in "AT" "BE" "CH" "DE" "DK" "EL" "ES" "FI" "FR" "IT" "NL" "PT" "SE" "UK" {
	replace insample= 1 if country=="`country'"
}
keep if insample==1
	
label var area_sq_km "Area in Square Kilometers"

tempfile duplicate 
save 	`duplicate'

append using `duplicate' 
append using `duplicate'
append using `duplicate'
append using `duplicate'
append using `duplicate'

bys nuts: gen n = _n

gen year 	= 1968 if n==1
replace year 	= 1969 if n==2
replace year 	= 1970 if n==3
replace year 	= 1971 if n==4
replace year 	= 1972 if n==5
replace year 	= 1973 if n==6  

drop country insample geo2012 n
tempfile EU_area
save	`EU_area.dta'

*-------------------------------------------------------------------------------
* a) US Land Area
*-------------------------------------------------------------------------------

insheet using "$insheet_files/USA/US_area_states.csv", clear

gen area_sq_km=sq_mi * 1.60934
	drop sq_mi
	
sort statefip
tempfile US_area
save `US_area.dta'
	
*-------------------------------------------------------------------------------
* b) CA Land Area 
*-------------------------------------------------------------------------------
insheet using "$insheet_files/Canada/CA_area.csv", clear

gen area_sq_km=area_sq_mi * 1.60934
	drop area_sq_mi
	
sort provca
tempfile CA_area
save `CA_area.dta'
	
	
*===============================================================================
* II) Motorways 
*===============================================================================

*-------------------------------------------------------------------------------
* a) EU Motorways 
*-------------------------------------------------------------------------------

cd "$insheet_files/Eurostat Web Data"
import excel using "EU_motorways.xlsx", first clear

gen country = substr(nuts,1,2)
gen insample=0
	
foreach country in "AT" "BE" "CH" "DE" "DK" "EL" "ES" "FI" "FR" "IT" "NL" "PT" "SE" "UK" {
	replace insample= 1 if country=="`country'"
}
keep if insample==1
	
forval y=1978/2011 {
	quietly replace y`y'=. if y`y'==0
}

keep nuts y*
duplicates drop
reshape long y, i(nuts) j(year)

rename y motorways_kilometers
label var motorways_kilometers "Kilometers of Motorways"

* b. replace missing values with 1s for regions with no motorways 
replace motorways = 1 if nuts=="UKM5"|nuts=="UKM6"

tempfile EU_motorways
save 	`EU_motorways.dta'

*-------------------------------------------------------------------------------
* b) US Motorways 
*-------------------------------------------------------------------------------

insheet using "$insheet_files/USA/US_highway_1978.csv", clear

egen motorways_miles=rsum(municipal federal*)
gen motorways_kilometers = motorways_miles * 1.60934
	drop motorways_miles
	
	
drop if statefip==43 //drop Puerto Rico

keep motor statefip 

merge 1:1 statefip using `US_area.dta', nogen

tempfile US_states
save 	`US_states.dta'

sort statefip

*By Region
gen region = 0 if statefip ==0 
replace region=	840004 if statefip == 1
replace region=	840009 if statefip == 2
replace region=	840008 if statefip == 4
replace region=	840005 if statefip == 5
replace region=	840010 if statefip == 6
replace region=	840008 if statefip == 8
replace region=	840001 if statefip == 9
replace region=	840003 if statefip == 10
replace region=	840003 if statefip == 11
replace region=	840003 if statefip == 12
replace region=	840003 if statefip == 13
replace region=	840003 if statefip == 14
replace region=	840009 if statefip == 15
replace region=	840008 if statefip == 16
replace region=	840006 if statefip == 17
replace region=	840006 if statefip == 18
replace region=	840007 if statefip == 19
replace region=	840007 if statefip == 20
replace region=	840004 if statefip == 21
replace region=	840005 if statefip == 22
replace region=	840001 if statefip == 23
replace region=	840003 if statefip == 24
replace region=	840001 if statefip == 25
replace region=	840006 if statefip == 26
replace region=	840007 if statefip == 27
replace region=	840004 if statefip == 28
replace region=	840007 if statefip == 29
replace region=	840008 if statefip == 30
replace region=	840007 if statefip == 31
replace region=	840008 if statefip == 32
replace region=	840001 if statefip == 33
replace region=	840002 if statefip == 34
replace region=	840008 if statefip == 35
replace region=	840002 if statefip == 36
replace region=	840003 if statefip == 37
replace region=	840007 if statefip == 38
replace region=	840006 if statefip == 39
replace region=	840005 if statefip == 40
replace region=	840009 if statefip == 41
replace region=	840002 if statefip == 42
replace region=	840001 if statefip == 44
replace region=	840003 if statefip == 45
replace region=	840007 if statefip == 46
replace region=	840004 if statefip == 47
replace region=	840005 if statefip == 48
replace region=	840008 if statefip == 49
replace region=	840001 if statefip == 50
replace region=	840003 if statefip == 51
replace region=	840009 if statefip == 53
replace region=	840003 if statefip == 54
replace region=	840006 if statefip == 55
replace region=	840008 if statefip == 56

collapse (sum) motor area, by(region)

append using `US_states.dta'

gen nuts=statefip
tostring nuts, replace force
replace nuts = "US: AK" if nuts=="2" 
replace nuts = "US: AL" if nuts=="1" 
replace nuts = "US: AR" if nuts=="5" 
replace nuts = "US: AS" if nuts=="60" 
replace nuts = "US: AZ" if nuts=="4" 
replace nuts = "US: CA" if nuts=="6" 
replace nuts = "US: CO" if nuts=="8" 
replace nuts = "US: CT" if nuts=="9" 
replace nuts = "US: DC" if nuts=="11" 
replace nuts = "US: DE" if nuts=="10" 
replace nuts = "US: FL" if nuts=="12" 
replace nuts = "US: GA" if nuts=="13" 
replace nuts = "US: GU" if nuts=="66" 
replace nuts = "US: HI" if nuts=="15" 
replace nuts = "US: IA" if nuts=="19" 
replace nuts = "US: ID" if nuts=="16" 
replace nuts = "US: IL" if nuts=="17" 
replace nuts = "US: IN" if nuts=="18" 
replace nuts = "US: KS" if nuts=="20" 
replace nuts = "US: KY" if nuts=="21" 
replace nuts = "US: LA" if nuts=="22" 
replace nuts = "US: MA" if nuts=="25" 
replace nuts = "US: MD" if nuts=="24" 
replace nuts = "US: ME" if nuts=="23" 
replace nuts = "US: MI" if nuts=="26" 
replace nuts = "US: MN" if nuts=="27" 
replace nuts = "US: MO" if nuts=="29" 
replace nuts = "US: MS" if nuts=="28" 
replace nuts = "US: MT" if nuts=="30" 
replace nuts = "US: NC" if nuts=="37" 
replace nuts = "US: ND" if nuts=="38" 
replace nuts = "US: NE" if nuts=="31" 
replace nuts = "US: NH" if nuts=="33" 
replace nuts = "US: NJ" if nuts=="34" 
replace nuts = "US: NM" if nuts=="35" 
replace nuts = "US: NV" if nuts=="32" 
replace nuts = "US: NY" if nuts=="36" 
replace nuts = "US: OH" if nuts=="39" 
replace nuts = "US: OK" if nuts=="40" 
replace nuts = "US: OR" if nuts=="41" 
replace nuts = "US: PA" if nuts=="42" 
replace nuts = "US: PR" if nuts=="72" 
replace nuts = "US: RI" if nuts=="44" 
replace nuts = "US: SC" if nuts=="45" 
replace nuts = "US: SD" if nuts=="46" 
replace nuts = "US: TN" if nuts=="47" 
replace nuts = "US: TX" if nuts=="48" 
replace nuts = "US: UT" if nuts=="49" 
replace nuts = "US: VA" if nuts=="51" 
replace nuts = "US: VI" if nuts=="78" 
replace nuts = "US: VT" if nuts=="50" 
replace nuts = "US: WA" if nuts=="53" 
replace nuts = "US: WI" if nuts=="55" 
replace nuts = "US: WV" if nuts=="54" 
replace nuts = "US: WY" if nuts=="56" 
replace nuts = "Entire U.S." if region==0
replace nuts = "US: New England" if region== 840001 
replace nuts = "US: Middle Atlantic States" if region==840002
replace nuts = "US: South Atlantic" if region==840003	
replace nuts = "US: East South Central" if region==840004	
replace nuts = "US: West South Central" if region==840005	
replace nuts = "US: East North Central" if region==840006	
replace nuts = "US: West North Central" if region==840007	
replace nuts = "US: Rocky Mountain state" if region==840008	
replace nuts = "US: Northwest" if region==840009
replace nuts = "US: California" if region==840010

keep nuts area region motorways

gen year = 1978

tempfile US_motorways
save `US_motorways.dta'

*===============================================================================
* c) CA Motorways 
*===============================================================================

insheet using "$insheet_files/Canada/CA_highway_1978.csv", clear

gen motorways_kilometers = highway * 1.60934
	drop highway

sort provca

merge 1:1 provca using `CA_area.dta', nogen

tempfile motorways
save `motorways.dta'


gen region=1 if provca==0

replace region= 124001 if provca ==2
replace region= 124002 if provca ==3
replace region= 124003 if provca ==4
replace region= 124004 if provca ==5
replace region= 124005 if provca ==6
replace region= 124006 if provca ==7
replace region= 124007 if provca ==8 
replace region= 124008 if provca ==9
replace region= 124009 if provca ==10
replace region= 124010 if provca ==1

drop if region==. //Yukon territory

#delim ;
label define region_wvs_labels  
1 "Canada"
124001 "Prince Edward Island"
124002 "Nova Scotia" 
124003 "New Brunswick"
124004 "Quebec" 
124005 "Ontario" 
124006 "Manitoba" 
124007 "Saskatchewan" 
124008 "Alberta"
124009 "British Columbia"
124010 "Newfoundland and Labrador" ;
#delim cr 

gen nuts = ""
replace nuts = "Canada" if region ==1
replace nuts = "CA: Prince Edward Island" if region == 124001
replace nuts =  "CA: Nova Scotia"  if region ==  124002
replace nuts =  "CA: New Brunswick"  if region == 124003
replace nuts =  "CA: Quebec"  if region == 124004
replace nuts =  "CA: Ontario"  if region ==  124005
replace nuts =  "CA: Manitoba"  if region ==  124006
replace nuts =  "CA: Saskatchewan"  if region ==  124007
replace nuts =  "CA: Alberta" if region ==  124008
replace nuts =  "CA: British Columbia"  if region == 124009
replace nuts =  "CA: Newfoundland and Labrador"  if region == 124010

label val region region_wvs_labels

drop  provca 
gen year = 1978 

*===============================================================================
* III) Append all data
*===============================================================================
append using `EU_motorways.dta'
	merge 1:1 nuts year using `EU_area.dta', update
	
append using `US_motorways.dta'

tempfile append
save 	`append.dta'

gen composite_nuts=""
replace composite_nuts="FR82&FR83" if nuts=="FR82"|nuts=="FR83"
replace composite_nuts="NL21&NL23" if nuts=="NL21"|nuts=="NL23"
replace composite_nuts="ITH1&ITH2" if nuts=="ITH1"|nuts=="ITH2"
replace composite_nuts="DE91&DE92" if nuts=="DE91"|nuts=="DE92"
replace composite_nuts="DE71&DE72" if nuts=="DE71"|nuts=="DE72"
drop if composite_nuts==""

collapse (sum) area motor, by(composite_nuts year) 

rename composite_nuts nuts 

append using `append.dta'

gen country =substr(nuts,1,2)
keep if country=="UK"|country=="SE"|country=="NL"|country=="IT"| ///
	country=="FR"|country=="ES"|country=="DK"|country=="DE"| ///
	country=="CH"|country=="BE"|country=="AT"|country=="FI"|country=="US"| ///
	country=="CA"

replace motor = . if motor ==0 
replace area = . if area ==0 

keep motorways_kilometers area_sq_km nuts year

save "$dta_files/motorways.dta", replace
